﻿var caseRestrictions = {
    context: $(".v-caseRestrictions"),
    datatable: null,
    initialize: function () {
        caseRestrictions.initializeDataTable();

        a4.initializeInputs(caseRestrictions.context);
    },
    initializeDataTable: function () {
        this.datatable = $(".h-caseRestrictionsTable", this.context).a4datatable({
            ajaxAction: a4.getProjectAction("GetCaseRestrictions", "Settings"),
            advancedFilter: true,
            height: "full",
            stateKey: "CaseRestrictions",
            columns: [
                { "Name": "Id", "Title": resources.Id, "Data": "Id", "Width": "50px" },
                { "Name": "UserName", "Title": resources.UserName, "Data": "UserName" },
                { "Name": "Criterion", "Title": resources.Criterion, "Data": "Criterion" },
                { "Name": "Comment", "Title": resources.Comments, "Data": "Comment" },
                { "Name": "Enabled", "Title": resources.Status, "Data": "EnabledLabel", "Width": "150px", "Type": "boolean", "AdvancedFilterLabels": { "0": resources.Inactive, "1": resources.Active } }
            ],
            localizableTexts: { "Search": resources.SearchCaseRestrictions },
            toolBarItems: [
                { "Action": "delete", "Label": resources.Delete }
            ],
            contextMenuItems: [
                { "Action": "delete", "Label": resources.Delete },
                { "Action": "properties", "Label": resources.Properties }
            ],
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;

                switch (action) {
                    case "delete":
                        caseRestrictions.deleteRestrictions([row.Id]);
                        break;

                    case "properties":
                        modalDialog.showWindow(a4.getProjectAction("EditCaseRestriction", "Settings", { id: row.Id }), 450, 700, { afterClose: function () { caseRestrictions.refreshContent(); } });
                        break;
                }
            },
            toolBarClick: function (event, data) {
                var rows = data.rows;
                var action = data.action;
                var ids = _.pluck(rows, "Id");

                if (action == "delete") {
                    caseRestrictions.deleteRestrictions(ids);
                }
            },
            draw: function (event, data) {
                var totalRecords = data.totalRecords || 0;

                $(".h-exportCaseRestrictions", caseRestrictions.context).toggle(totalRecords > 0);
                $(".h-exportCaseRestrictions", caseRestrictions.context).prev(".divider").toggle(totalRecords > 0);
            }
        });
    },
    bindEvents: function () {
        this.context.on("click", ".h-addRestriction", function () {
            modalDialog.showWindow(a4.getProjectAction("EditCaseRestriction", "Settings"), 450, 700, { afterClose: function () { caseRestrictions.refreshContent(); } });
        });

        this.context.on("click", ".h-copyCaseRestrictions", function () {
            a4.showSelectProjectDialog(function (sourceProjectId) {
                a4.callServerMethod(a4.getProjectAction("CopyCaseRestrictions", "Settings"), { sourceProjectId: sourceProjectId },
                function (result) {
                    caseRestrictions.refreshContent();
                });
            }, resources.CaseRestrictionsTitle);
        });

        this.context.on("click", ".h-exportCaseRestrictions", function () {
            a4.showBusyBox();

            a4.callServerMethod(a4.getProjectAction("ExportCaseRestrictions", "Settings"), {},
                function (result) {
                    a4.hideBusyBox();
                    window.location = a4.getProjectAction("GetCaseRestrictionsFile", "Settings", { fileName: result });
                });
        });
    },
    deleteRestrictions: function (ids) {
        modalDialog.showConfirmDelete(confirmDeleteItemsResources, function () {
            a4.callServerMethod(a4.getProjectAction("DeleteCaseRestrictions", "Settings"), { ids: ids },
                function (result) {
                    caseRestrictions.refreshContent();
                });
        }, ids.length);
    },
    refreshContent: function () {
        this.datatable.a4datatable("refresh");
    }
}

$(document).ready(function () {
    if (caseRestrictions.context.length > 0)
    {
        caseRestrictions.initialize();
        caseRestrictions.bindEvents();
    }
});